/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.NativeProcess;
import com.ibm.hwmca.fw.util.NativeProcessParameters;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;

public class RootProcess {
    public static final String RUN_AS_ROOT_PROGRAM_NAME = "runAsRoot";
    private static final String TRACE_MASKT = "XREMRTPT";
    private static final String TRACE_MASKF = "XREMRTPF";
    private static final String TRACE_MASKD = "XREMRTPD";

    public static int executeProgram(String command) throws IOException {
        Trace.trace(TRACE_MASKT, "-> executeProgram(String)");
        NativeProcess np = NativeProcess.exec(new NativeProcessParameters(RootProcess.buildCommandString(command)));
        int rc = RootProcess.getExitStatus(np);
        Trace.trace(TRACE_MASKT, "<- executeProgram; target program's rc=" + rc);
        return rc;
    }

    public static int executeProgram(String[] command) throws IOException {
        Trace.trace(TRACE_MASKT, "-> executeProgram(String[])");
        NativeProcess np = NativeProcess.exec(new NativeProcessParameters(RootProcess.buildCommandArray(command)));
        int rc = RootProcess.getExitStatus(np);
        Trace.trace(TRACE_MASKT, "<- executeProgram; target program's rc=" + rc);
        return rc;
    }

    public static Process startProgram(String command) throws IOException {
        Trace.trace(TRACE_MASKT, "-> startProgram(String)");
        Process p = Runtime.getRuntime().exec(RootProcess.buildCommandString(command));
        Trace.trace(TRACE_MASKT, "<- startProgram");
        return p;
    }

    public static Process startProgram(String[] command) throws IOException {
        Trace.trace(TRACE_MASKT, "-> startProgram(String[])");
        Process p = Runtime.getRuntime().exec(RootProcess.buildCommandArray(command));
        Trace.trace(TRACE_MASKT, "<- startProgram");
        return p;
    }

    private static String buildCommandString(String command) {
        return "runAsRoot " + command;
    }

    private static String[] buildCommandArray(String[] command) {
        String[] rootCommand = new String[command.length + 1];
        rootCommand[0] = RUN_AS_ROOT_PROGRAM_NAME;
        for (int i = 1; i <= command.length; ++i) {
            rootCommand[i] = command[i - 1];
        }
        return rootCommand;
    }

    private static int getExitStatus(NativeProcess np) {
        boolean done = false;
        int exitStatus = -1;
        while (!done) {
            try {
                exitStatus = np.waitFor();
                done = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        Trace.trace(TRACE_MASKF, "Exit status from root program = " + exitStatus);
        return exitStatus;
    }
}

